<?php
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');
?>
<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'szkolenie-form',
	'enableAjaxValidation'=>false,
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'nazwa'); ?>
		<?php echo $form->textField($model,'nazwa',array('size'=>60,'maxlength'=>64)); ?>
		<?php echo $form->error($model,'nazwa'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'idDziedzina'); ?>
		<?php echo $form->dropDownList($model,'idDziedzina',array(''=>'Wybierz dziedzinę')+CHtml::listData(Dziedzina::model()->findAll('"id" NOT IN (5,6)'),'id','nazwa')); ?>
		<?php echo $form->error($model,'idDziedzina'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'poziom'); ?>
		<?php echo $form->dropDownList($model,'poziom',array(''=>'Wybierz poziom')+Szkolenie::getPoziomy()); ?>
		<?php echo $form->error($model,'poziom'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czyEgzamin'); ?>
		<?php echo $form->checkBox($model,'czyEgzamin'); ?>
		<?php echo $form->error($model,'czyEgzamin'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czasTrwania'); ?>
		<?php echo $form->textField($model,'czasTrwania'); ?>
		<?php echo $form->error($model,'czasTrwania'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'cena'); ?>
		<?php echo $form->textField($model,'cena'); ?>
		<?php echo $form->error($model,'cena'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tresc'); ?>
		<?php echo $form->textArea($model,'tresc',array('size'=>60,'maxlength'=>40000,'cols'=>60,'rows'=>8)); ?>
		<?php echo $form->error($model,'tresc'); ?>
	</div>

	<?php if($model->czyEgzamin): ?>
		<a href="<?php echo $this->createUrl('/administration/szkolenie/exam',array('id'=>$model->id)) ?>">Przejdź do edycji egzaminu</a>
	<?php endif; ?>

	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Utwórz' : 'Zapisz',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>

<script type="text/javascript">
(function()
{
	$('.form').on('click', '.removeAnswer',function(){
		$(this).parent().remove();
		var i = 1;
		$("#answersContainer").find('label').each(function(){
			$(this).text('#'+i);
			i++;
		});
		return false;
	});

	initTimeField($('#Szkolenie_czasTrwania'));
	$('#szkolenie-form').submit(function(){
		serializeTimeField($('#Szkolenie_czasTrwania'));
	});

})();
</script>
